<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
 
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
?>
				<h1>User Activity Summary</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<?php echo $tabs;?>
						</ul>
					<div class="tab-content">
						<p>This report displays the activity of each user in the system.</p>
						<?PHP echo form_open('/reports/user_activity_summary',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', 1, ".$form_data['items_per_page'].", '');")); ?>
											<table class="form">
								<tr class="form_row">
									<td>Facility:</td>
									<td>
										<?php if($all_report){?>
										<select class="fill_row" id="whichfacility" name="whichfacility" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<?php foreach($facilities as $facility){ ?>
											<option value="<?php echo $facility->id;?>" <?php if (isset($form_data['whichfacility']) && $facility->id==$form_data['whichfacility']){echo "selected";}?>><?php echo $facility->name;?></option>
											<?php  } ?>
										</select>
										<?php }else{echo $facility;}?>
									</td>
								</tr>
								<tr class="form_row">
									<td>First Name:</td>
									<td>
									<p class="hidden_context" style="display:none;" id="acting_user_help">User First Name</p>
									<input type="text" id="txtGivenname" name="txtGivenname" value="<?php if(isset($form_data['txtGivenname'])) { echo htmlentities($form_data['txtGivenname']); } ?>"/></td>
									<td>
										<label class="hidden_context">Compare First Name</label>
										<select id="first_name_type" name="first_name_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['first_name_type']) && $key == $form_data['first_name_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td>VA Email Address:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="acting_user_help">User VA Email Address</p>
										<input id="txtVAEmailAddress" name="txtVAEmailAddress" type="text" title="VA Email Address" value="<?php if(isset($form_data['txtVAEmailAddress'])) { echo htmlentities($form_data['txtVAEmailAddress']); } ?>"></input>
									</td>
									<td>
										<label class="hidden_context">Compare VA Email Address</label>
										<select id="va_email_type" name="va_email_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['va_email_type']) && $key == $form_data['va_email_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td>Last Name:</td>
									<td>
									<p class="hidden_context" style="display:none;" id="txtSN">User Last Name</p>
									<input type="text" id="txtSN" name="txtSN" title="VA Email Address" value="<?php if(isset($form_data['txtSN'])) { echo htmlentities($form_data['txtSN']); } ?>"/></td>
									<td>
										<label class="hidden_context">Compare options for Last Name</label>
										<select id="last_name_type" name="last_name_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['last_name_type']) && $key == $form_data['last_name_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td>Direct Address:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="acting_user_help">User Direct Address</p>
										<input type="text" id="txtDirectAddress" name="txtDirectAddress" value="<?php if(isset($form_data['txtDirectAddress'])) { echo htmlentities($form_data['txtDirectAddress']); } ?>"/></td>
									</td>
									<td>
										<label class="hidden_context">Compare options for Direct Address</label>
										<select id="direct_address_type" name="direct_address_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['direct_address_type']) && $key == $form_data['direct_address_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td>User Name:</td>
									<td>
									<p class="hidden_context" style="display:none;" id="acting_user_help">User Name</p>
									<input type="text" id="txtUserName" name="txtUserName" value="<?php if(isset($form_data['txtUserName'])) { echo htmlentities($form_data['txtUserName']); } ?>"/></td>
									<td>
										<label class="hidden_context">Compare User Name</label>
										<select id="userName_type" name="userName_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['userName_type']) && $key == $form_data['userName_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td>User Status:</td>
									<td>
										<p class="hidden_context" style="display:none;" id="acting_user_help">User Status Active or Inactive</p>
										<select class="fill_row" id="user_status_type" name="user_status_type" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="1" <?php if(isset($form_data['user_status_type']) && $form_data['user_status_type'] == "1"){echo "selected";}?>>Active</option>
											<option value="0" <?php if(isset($form_data['user_status_type']) && $form_data['user_status_type'] == "0"){echo "selected";}?>>Inactive</option>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td>Start Date:</td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo htmlentities($form_data['start_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
									<td>&nbsp;</td>
									<td>End Date:</td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo htmlentities($form_data['end_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
									<td>&nbsp;</td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt" , timeSuffix: ' '+timezone_abbr});</script>
							</table>
							<?PHP
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'export_pdf' => '0',
									'print_page' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<div id="date_error_message" class="message_error" style="display: none;"></div>
							<?php if(count((array)$summary_list) == 0) { ?>
								<div class="message">There is no users information to display for the selected criteria.</div>
							<?php }else{ 
								if(!empty($form_data['date_warning_message'])) { ?>
									<div class="message"><?php echo $form_data['date_warning_message']; ?></div>
								<?PHP } ?>
								<?php if(sizeof($summary_list) != 0) { ?>
									<div class="pagination">
										<?php echo $form_data['pages']->display_result_num();?>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
										<?php echo $form_data['pages']->display_items_per_page();?>
										<div style="float:right; position: relative;">
											<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
												<a href="#" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } 
											else { ?>
												<a href="#" onclick="if ( confirm('You are going to export <?php echo $form_data['pages']->items_total; ?> records and this will take a few minutes. Are you sure you want to proceed?')){ $('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');}"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } ?>
											<a id="export_pdf" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
											<a href="#"  onclick="$('#print_page').attr('value','1');$('#reports_form').submit();$('#print_page').attr('value','0');"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
											<label class="hidden_context">Page Selector</label>
											<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
											<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
										</div>
									</div>
								<?php }?> 
							<?php }?> 
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/user_activity_summary',array('id'=>'clear_form')); echo form_close(); 
						$this->load->view('api/reports/result_tables/result_user_activity_summary');
						?>
							
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position: relative;">
									<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
										<a href="#" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } 
									else { ?>
										<a href="#" onclick="if ( confirm('You are going to export <?php echo $form_data['pages']->items_total; ?> records and this will take a few minutes. Are you sure you want to proceed?')){ $('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');}"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } ?>
									<a id="export_pdf" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
									<a href="#"  onclick="$('#print_page').attr('value','1');$('#reports_form').submit();$('#print_page').attr('value','0');"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
									<label class="hidden_context">Page Selector</label>
									<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							
						</div>
					</div>
				</div>
			</div>
			<?php $this->load->view('api/reports/result_tables/file_downloading_window');?>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>